#include "main.h"

_player player;

void _shot::move()
{
	x += xv;
	y += yv;
}

void _shot::draw()
{
	if (player.insane)
	{
		buffer_rotate_sprite(shot[CRAZY],int(x), int(y), ftofix(atan2(yv, xv) * 128 / PI + 64));
	}
	else
	{
		buffer_rotate_sprite(shot[SANE],int(x), int(y), ftofix(atan2(yv, xv) * 128 / PI + 64));
	}
}

bool _shot::offscreen()
{
	if (x < -w) return true;
	if (x > SCREEN_W) return true;
	if (y < -h) return true;
	if (y > SCREEN_H) return true;
	return false;
}

//==============================================================================
//==============================================================================

void _player::do_stuff()
{
	list<_shot>::iterator it;
	float invert = 1;
	
	if (player.insane)
	{
		invert = -1;
	}
	
	if ((key[KEY_LEFT]) || (key[KEY_A]))
	{
		xv = -3 * invert;
	}
	else if ((key[KEY_RIGHT]) || (key[KEY_D]))
	{
		xv = 3 * invert;
	}
	else
	{
		xv /= 1.2;
	}
	if ((key[KEY_UP]) || (key[KEY_W]))
	{
		yv = -3 * invert;
	}
	else if ((key[KEY_DOWN]) || (key[KEY_S]))
	{
		yv = 3 * invert;
	}
	else
	{
		yv /= 1.2;
	}
	
	if (player.twoplayer)
	{
		if (shotdelay2 <= 0)
		{
			if (mouse_b & 1)
			{
				p2_fire();
				if (player.insane)
				{
					play_sample(sboing, 255, 128, 1000, 0);
				}
				else
				{
					play_sample(sfire, 255, 128, 1000, 0);
				}
				shotdelay2 = 20;
			}
		}
		else
		{
			shotdelay2--;
		}
	}
	
	if (shotdelay <= 0)
	{
		if ((key[KEY_LCONTROL]) || (key[KEY_SPACE]))
		{
			fire();
			if (player.insane)
			{
				play_sample(sboing, 255, 128, 1000, 0);
			}
			else
			{
				play_sample(sfire, 255, 128, 1000, 0);
			}
			shotdelay = 15;
		}
	}
	else
	{
		shotdelay--;
	}
	
	it = pshot.begin();
	while (it != pshot.end())
	{
		(*it).move();
		(*it).draw();
		if ((*it).offscreen())
		{
			it = pshot.erase(it);
			it--;
		}
		it++;
	}
	
	new_particle(P_ENGINE, int(x) + 5 + rand()%15, int(y) + 20 + rand()%3, 0, 0.5 + float(rand()%50) / 10);
	new_particle(P_ENGINE, int(x) + 5 + rand()%15, int(y) + 20 + rand()%3, 0, 0.5 + float(rand()%50) / 10);
	
	move();
	draw();
}

void _player::move()
{
	x += xv;
	y += yv;
	
	if (x < 0) x = 0;
	if (x + w > SCREEN_W) x = SCREEN_W - w;
	if (y < 0) y = 0;
	if (y + h > SCREEN_H) y = SCREEN_H - h;
}

void _player::take_damage(int damage)
{
	if (player.insane)
	{
		play_sample(shurt, 255, 128, 1000, 0);
		health -= damage / 2;
	}
	else
	{
		craziness += damage;
		play_sample(sow, 255, 128, 1000, 0);
	}
}

void _player::draw()
{
	buffer_draw_sprite(ship, int(x), int(y));
	
	if (player.twoplayer)
	{
		buffer_draw_sprite(targeting, mouse_x, mouse_y);
	}
}

void _player::fire()
{
	_shot s;
	
	switch (shotmode)
	{
		case SHOT_NORMAL:
			s.x = x + w / 2;
			s.y = y + 2;
			s.xv = 0;
			s.yv = -5;
			pshot.push_back(s);
			break;
		case SHOT_DOUBLE:
			s.x = x - 10 + w / 2;
			s.y = y + 2;
			s.xv = 0;
			s.yv = -5;
			pshot.push_back(s);
			s.x = x + 10 + w / 2;
			s.y = y + 2;
			s.xv = 0;
			s.yv = -5;
			pshot.push_back(s);
			break;
		case SHOT_SPREAD:
			s.x = x + w / 2;
			s.y = y + 2;
			s.xv = 0;
			s.yv = -5;
			pshot.push_back(s);
			s.x = x + 10 + w / 2;
			s.y = y + 2;
			s.xv = 3;
			s.yv = -5;
			pshot.push_back(s);
			s.x = x - 10 + w / 2;
			s.y = y + 2;
			s.xv = -3;
			s.yv = -5;
			pshot.push_back(s);
			break;
	}
}

void _player::p2_fire()
{
	const float speed = 5;
	float angle;
	_shot s;
	
	if (player.insane)
	{
		angle = atan2(y - mouse_y, x - mouse_x);
	}
	else
	{
		angle = atan2(mouse_y - y, mouse_x - x);
	}
	
	s.x = x + 12.5;
	s.y = y + 12.5;
	s.xv = speed * cos(angle);
	s.yv = speed * sin(angle);
	pshot.push_back(s);
}

void _player::init(bool _twoplayer)
{
	insane = false;
	twoplayer = _twoplayer;
	shotmode = SHOT_NORMAL;
	shotdelay = 0;
	shotdelay2 = 0;
	x = SCREEN_W / 2 - w / 2;
	y = SCREEN_H - h - 20;
	xv = 0;
	yv = 0;
	craziness = 0;
	health = 100;
	timesinsane = 0;
}
